<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use View;
use Illuminate\Support\Facades\Config;
use App\Models\Setting;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        $siteSettings = widget(1);
        View::share([
            'siteSettings' => $siteSettings
        ]);

        $mailSettings = widget(26);
        
        if ($mailSettings) {
            Config::set('mail.mailers.smtp.host', $mailSettings->extra_field_1);
            Config::set('mail.mailers.smtp.port', $mailSettings->extra_field_2);
            Config::set('mail.mailers.smtp.username', $mailSettings->extra_field_3);
            Config::set('mail.mailers.smtp.password', $mailSettings->extra_field_4);
            Config::set('mail.mailers.smtp.encryption', $mailSettings->extra_field_5);
            Config::set('mail.from.address', $mailSettings->extra_field_6);
            Config::set('mail.from.name', $mailSettings->extra_field_7);
        }


        // Payment Gateway configurations from settings table
        // All payment gateway settings come from the settings table, not .env or hardcoded
        
        // Stripe config - from settings table only
        $stripeKey = Setting::getValue('stripe_key');
        $stripeSecret = Setting::getValue('stripe_secret');
        
        if (!empty($stripeKey) || !empty($stripeSecret)) {
            Config::set('services.stripe.key', $stripeKey ?? '');
            Config::set('services.stripe.secret', $stripeSecret ?? '');
        }

        // PayPal config - from settings table only
        $paypalClientId = Setting::getValue('paypal_client_id');
        $paypalSecret = Setting::getValue('paypal_secret');
        $paypalMode = Setting::getValue('paypal_mode', 'sandbox');
        
        if (!empty($paypalClientId) || !empty($paypalSecret)) {
            Config::set('services.paypal.client_id', $paypalClientId ?? '');
            Config::set('services.paypal.client_secret', $paypalSecret ?? '');
            Config::set('services.paypal.mode', !empty($paypalMode) ? $paypalMode : 'sandbox');
        }

        // Paystack config - from settings table only
        $paystackPublicKey = Setting::getValue('paystack_public_key');
        $paystackSecretKey = Setting::getValue('paystack_secret_key');
        $paystackMerchantEmail = Setting::getValue('paystack_merchant_email');
        
        if (!empty($paystackPublicKey) || !empty($paystackSecretKey)) {
            Config::set('services.paystack.public_key', $paystackPublicKey ?? '');
            Config::set('services.paystack.secret_key', $paystackSecretKey ?? '');
            Config::set('services.paystack.merchant_email', $paystackMerchantEmail ?? '');
            Config::set('services.paystack.url', 'https://api.paystack.co');
        }



    }
}
