<x-admin-layout>
    <div class="container">
        <div class="row mt-4">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">Payment Gateways</li>
                        </ol>
                    </div>
                    <h2 class="page-title mt-3 mb-2">Payment Gateway Settings</h2>
                </div>
            </div>
        </div>

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="row">
            <!-- Left Sidebar - Gateway Selection -->
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title mb-3">Payment Gateways</h5>
                        <div class="list-group list-group-flush">
                            <a href="{{ route('admin.payment-gateways.index', ['gateway' => 'paypal']) }}" 
                               class="list-group-item list-group-item-action {{ $gateway === 'paypal' ? 'active' : '' }}">
                                <div class="d-flex align-items-center">
                                <i class="fab fa-paypal me-2" style="font-size: 20px; color:rgb(0, 47, 255);"></i>
                                    <span>PayPal</span>
                                </div>
                            </a>
                            <a href="{{ route('admin.payment-gateways.index', ['gateway' => 'stripe']) }}" 
                               class="list-group-item list-group-item-action {{ $gateway === 'stripe' ? 'active' : '' }}">
                                <div class="d-flex align-items-center">
                                    <i class="fab fa-stripe me-2" style="font-size: 24px; color: #635BFF;"></i>
                                    <span>Stripe</span>
                                </div>
                            </a>
                            <a href="{{ route('admin.payment-gateways.index', ['gateway' => 'paystack']) }}" 
                               class="list-group-item list-group-item-action {{ $gateway === 'paystack' ? 'active' : '' }}">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-credit-card me-2" style="font-size: 20px; color: #00D9FF;"></i>
                                    <span>Paystack</span>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Section - Gateway Configuration -->
            <div class="col-md-9">
                <div class="card">
                    <div class="card-header">
                        <h4 class="header-title">
                            @if($gateway === 'paypal')
                                PayPal:
                            @elseif($gateway === 'stripe')
                                Stripe:
                            @elseif($gateway === 'paystack')
                                Paystack:
                            @endif
                        </h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.payment-gateways.update') }}" method="POST">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="gateway" value="{{ $gateway }}">

                            @if($gateway === 'paypal')
                                <!-- PayPal Configuration -->
                                <div class="mb-3">
                                    <label for="paypal_account" class="form-label">Paypal account:</label>
                                    <input type="email" 
                                           class="form-control" 
                                           id="paypal_account" 
                                           name="paypal_account" 
                                           value="{{ isset($settings['paypal_account']) ? $settings['paypal_account']->value : '' }}"
                                           placeholder="your-email@example.com">
                                </div>

                                <div class="mb-3">
                                    <label for="paypal_client_id" class="form-label">Paypal client_id:</label>
                                    <input type="text" 
                                           class="form-control" 
                                           id="paypal_client_id" 
                                           name="paypal_client_id" 
                                           value="{{ isset($settings['paypal_client_id']) ? $settings['paypal_client_id']->value : '' }}"
                                           placeholder="Enter PayPal Client ID">
                                </div>

                                <div class="mb-3">
                                    <label for="paypal_secret" class="form-label">Paypal secret:</label>
                                    <input type="password" 
                                           class="form-control" 
                                           id="paypal_secret" 
                                           name="paypal_secret" 
                                           value="{{ isset($settings['paypal_secret']) ? $settings['paypal_secret']->value : '' }}"
                                           placeholder="Enter PayPal Secret Key">
                                    <small class="form-text text-muted">Your PayPal secret key (will be masked for security)</small>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Is Sandbox?</label>
                                    <div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" 
                                                   type="radio" 
                                                   name="paypal_mode" 
                                                   id="paypal_sandbox" 
                                                   value="sandbox"
                                                   {{ (isset($settings['paypal_mode']) ? $settings['paypal_mode']->value : 'sandbox') === 'sandbox' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="paypal_sandbox">Sandbox</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" 
                                                   type="radio" 
                                                   name="paypal_mode" 
                                                   id="paypal_live" 
                                                   value="live"
                                                   {{ (isset($settings['paypal_mode']) ? $settings['paypal_mode']->value : '') === 'live' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="paypal_live">Live</label>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Is Paypal active?</label>
                                    <div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" 
                                                   type="radio" 
                                                   name="paypal_active" 
                                                   id="paypal_active_yes" 
                                                   value="yes"
                                                   {{ (isset($settings['paypal_active']) ? $settings['paypal_active']->value : 'no') === 'yes' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="paypal_active_yes">Yes</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" 
                                                   type="radio" 
                                                   name="paypal_active" 
                                                   id="paypal_active_no" 
                                                   value="no"
                                                   {{ (isset($settings['paypal_active']) ? $settings['paypal_active']->value : 'no') === 'no' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="paypal_active_no">No</label>
                                        </div>
                                    </div>
                                </div>

                            @elseif($gateway === 'stripe')
                                <!-- Stripe Configuration -->
                                <div class="mb-3">
                                    <label for="stripe_key" class="form-label">Stripe Key (Publishable Key):</label>
                                    <input type="text" 
                                           class="form-control" 
                                           id="stripe_key" 
                                           name="stripe_key" 
                                           value="{{ isset($settings['stripe_key']) ? $settings['stripe_key']->value : '' }}"
                                           placeholder="pk_test_... or pk_live_...">
                                </div>

                                <div class="mb-3">
                                    <label for="stripe_secret" class="form-label">Stripe Secret Key:</label>
                                    <input type="password" 
                                           class="form-control" 
                                           id="stripe_secret" 
                                           name="stripe_secret" 
                                           value="{{ isset($settings['stripe_secret']) ? $settings['stripe_secret']->value : '' }}"
                                           placeholder="sk_test_... or sk_live_...">
                                    <small class="form-text text-muted">Your Stripe secret key (will be masked for security)</small>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Is Test Mode?</label>
                                    <div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" 
                                                   type="radio" 
                                                   name="stripe_mode" 
                                                   id="stripe_test" 
                                                   value="test"
                                                   {{ (isset($settings['stripe_mode']) ? $settings['stripe_mode']->value : 'test') === 'test' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="stripe_test">Test</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" 
                                                   type="radio" 
                                                   name="stripe_mode" 
                                                   id="stripe_live" 
                                                   value="live"
                                                   {{ (isset($settings['stripe_mode']) ? $settings['stripe_mode']->value : '') === 'live' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="stripe_live">Live</label>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Is Stripe active?</label>
                                    <div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" 
                                                   type="radio" 
                                                   name="stripe_active" 
                                                   id="stripe_active_yes" 
                                                   value="yes"
                                                   {{ (isset($settings['stripe_active']) ? $settings['stripe_active']->value : 'no') === 'yes' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="stripe_active_yes">Yes</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" 
                                                   type="radio" 
                                                   name="stripe_active" 
                                                   id="stripe_active_no" 
                                                   value="no"
                                                   {{ (isset($settings['stripe_active']) ? $settings['stripe_active']->value : 'no') === 'no' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="stripe_active_no">No</label>
                                        </div>
                                    </div>
                                </div>

                            @elseif($gateway === 'paystack')
                            <div class="alert alert-warning">
                                            <i class="fas fa-exclamation-triangle"></i>
                                            Note: Paystack supports Nigerian Naira (NGN), Ghanaian Cedi (GHS), South African Rand (ZAR), Kenyan Shilling (KES), West African CFA Franc (XOF). we suggest to use only for these <a href="{{route('admin.currency-settings.index')}}" style="color:rgb(0, 0, 0); font-weight: bold;">currencies</a>.
                                        </div>  
                                <!-- Paystack Configuration -->
                                <div class="mb-3">
                                    <label for="paystack_public_key" class="form-label">Paystack Public Key:</label>
                                    <input type="text" 
                                           class="form-control" 
                                           id="paystack_public_key" 
                                           name="paystack_public_key" 
                                           value="{{ isset($settings['paystack_public_key']) ? $settings['paystack_public_key']->value : '' }}"
                                           placeholder="pk_test_... or pk_live_...">
                                </div>

                                <div class="mb-3">
                                    <label for="paystack_secret_key" class="form-label">Paystack Secret Key:</label>
                                    <input type="password" 
                                           class="form-control" 
                                           id="paystack_secret_key" 
                                           name="paystack_secret_key" 
                                           value="{{ isset($settings['paystack_secret_key']) ? $settings['paystack_secret_key']->value : '' }}"
                                           placeholder="sk_test_... or sk_live_...">
                                    <small class="form-text text-muted">Your Paystack secret key (will be masked for security)</small>
                                </div>

                                <div class="mb-3">
                                    <label for="paystack_merchant_email" class="form-label">Paystack Merchant Email:</label>
                                    <input type="email" 
                                           class="form-control" 
                                           id="paystack_merchant_email" 
                                           name="paystack_merchant_email" 
                                           value="{{ isset($settings['paystack_merchant_email']) ? $settings['paystack_merchant_email']->value : '' }}"
                                           placeholder="merchant@example.com">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Is Test Mode?</label>
                                    <div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" 
                                                   type="radio" 
                                                   name="paystack_mode" 
                                                   id="paystack_test" 
                                                   value="test"
                                                   {{ (isset($settings['paystack_mode']) ? $settings['paystack_mode']->value : 'test') === 'test' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="paystack_test">Test</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" 
                                                   type="radio" 
                                                   name="paystack_mode" 
                                                   id="paystack_live" 
                                                   value="live"
                                                   {{ (isset($settings['paystack_mode']) ? $settings['paystack_mode']->value : '') === 'live' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="paystack_live">Live</label>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Is Paystack active?</label>
                                    <div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" 
                                                   type="radio" 
                                                   name="paystack_active" 
                                                   id="paystack_active_yes" 
                                                   value="yes"
                                                   {{ (isset($settings['paystack_active']) ? $settings['paystack_active']->value : 'no') === 'yes' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="paystack_active_yes">Yes</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" 
                                                   type="radio" 
                                                   name="paystack_active" 
                                                   id="paystack_active_no" 
                                                   value="no"
                                                   {{ (isset($settings['paystack_active']) ? $settings['paystack_active']->value : 'no') === 'no' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="paystack_active_no">No</label>
                                        </div>

                                        
                                    </div>
                                </div>
                            @endif

                            <div class="mt-4">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Save Settings
                                </button>
                                <a href="{{ route('admin.currency-settings.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left"></i> Back
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .list-group-item.active {
            background-color: #f8f9fa;
            border-color: #dee2e6;
            color: #495057;
            font-weight: 600;
        }
        
        .list-group-item:hover {
            background-color: #f8f9fa;
        }
        
        .form-control:focus, .form-check-input:focus {
            border-color: #86b7fe;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }
    </style>
</x-admin-layout>

